/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.blocking;

import com.floragunn.searchguard.authc.blocking.BlockedIpRegistry;
import com.floragunn.searchguard.authc.blocking.Blocks;
import com.floragunn.searchguard.authc.blocking.ClientBlockRegistry;
import com.floragunn.searchguard.authc.blocking.WildcardVerdictBasedBlockRegistry;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;

public class BlockedUserRegistry {
    protected static final Logger log = LogManager.getLogger(BlockedIpRegistry.class);
    private volatile ClientBlockRegistry<String> blockedUsers;

    public BlockedUserRegistry(ConfigurationRepository configurationRepository) {
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<Blocks> blocks = configMap.get(CType.BLOCKS);
                if (blocks != null) {
                    BlockedUserRegistry.this.blockedUsers = BlockedUserRegistry.this.reloadBlockedUsers(blocks);
                    if (log.isDebugEnabled()) {
                        log.debug("Updated confiuration: " + blocks + "\nBlockedUsers: " + BlockedUserRegistry.this.blockedUsers);
                    }
                }
            }
        });
    }

    public boolean isUserBlocked(String userName) {
        if (userName == null) {
            return false;
        }
        if (this.blockedUsers == null) {
            return false;
        }
        return this.blockedUsers.isBlocked(userName);
    }

    private ClientBlockRegistry<String> reloadBlockedUsers(SgDynamicConfiguration<Blocks> blocks) {
        Tuple<Set<String>, Set<String>> b = this.readBlocks(blocks, Blocks.Type.name);
        return new WildcardVerdictBasedBlockRegistry((Set)b.v1(), (Set)b.v2());
    }

    private Tuple<Set<String>, Set<String>> readBlocks(SgDynamicConfiguration<Blocks> blocks, Blocks.Type type) {
        HashSet<String> allows = new HashSet<String>();
        HashSet<String> disallows = new HashSet<String>();
        List blocksV7s = blocks.getCEntries().values().stream().filter(b -> b.getType() == type).collect(Collectors.toList());
        for (Blocks blocksV7 : blocksV7s) {
            if (blocksV7.getVerdict() == null) {
                log.error("No verdict type found in blocks");
                continue;
            }
            if (blocksV7.getVerdict() == Blocks.Verdict.disallow) {
                disallows.addAll((Collection<String>)blocksV7.getValue());
                continue;
            }
            if (blocksV7.getVerdict() == Blocks.Verdict.allow) {
                allows.addAll((Collection<String>)blocksV7.getValue());
                continue;
            }
            log.error("Found unknown verdict type: " + (Object)((Object)blocksV7.getVerdict()));
        }
        return new Tuple(allows, disallows);
    }
}

